
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Sun Mar 06 20:41:57 2005
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_Ext_ATP_RND_Acceptance.c#1:csrc:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
#include "CRYS.h"

#include "CRYS_Ext_ATP_TST_Defines.h"
#include "CRYS_ATP_TST_UTIL_Funcs.h"
#include "CRYS_Ext_ATP_RND_Acceptance.h"


#include "DX_VOS_Mem.h"


extern DxUint8_t FailureFunctionNameOut[FailureFunctionName_K_Size];

/******** Defines **********/
/******** Enums **********/
/******** Typedefs **********/
/******** Global Data **********/
/***** Private function prototype ******/
/******** Public Functions **********/
CRYSError_t SEPQA_ATP_CheckErrorReturn(CRYSError_t  TST_ErrorRet,
									   char         TST_FuncName[TST_FUNC_STRING_LEN],
									   DxUint8_t   *FailureFunctionNameOut_ptr);
/***************************
 * Function Name:                                                           
 *  CRYS_Ext_ATP_RND_Acceptance_No_Reset        
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for Random API's,
 *  implemented as external SEP application  
 *                                  
 * Algorithm:       
 * 1. Call the SEPQA_ECC_ECDSA_NonIntegratedSignVerify function to execute test
 * 2. Verify function succeded according to the returned error code
 *
 **************************/ 
CRYSError_t CRYS_Ext_ATP_RND_Acceptance_No_Reset ( void )
{

    /*** TST Variables Definitions ****/
    TST_RND_TestDataStruct  TST_RND_Results = {{0},{0}};    
    DxUint16_t              TST_RNDSize = 750;
    CRYSError_t             TST_TestStatus=0;
    char                    TST_MasterTestName[TST_FUNC_STRING_LEN] = "CRYS_ATP_TST_RND_Acceptance_No_Reset";

    
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"************************ \n"));
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"** CRYS_ATP_TST_RND_Acceptance_No_Reset Tests       ******** \n"));       
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"************************ \n \n"));

    /****************/
    /***** Start of test ********/
    /****************/
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," ************************ \n"));
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," Random generation - Random Size = %d \n", TST_RNDSize));
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," ************************ \n"));

	TST_ATP_Error = SEPQA_RND_No_Reset(TST_RNDSize,
										FailureFunctionNameOut,
										FailureFunctionName_K_Size);

	if (TST_ATP_Error == TESTPASS)
	{

		ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n!!!! TST_ATP_Error - Master Test Name -%s\n",TST_MasterTestName));
		ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"!!!! TST_ATP_Error - SubTest Name -%s\n","TST_RND_Output1+2"));           
		ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"!!!! TST_ATP_Error - %s failed\n","DX_VOS_MemCmp"));
		ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"!!!! TST_ATP_Error - Wrong Error returned!\n"));
		ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"!!!! TST_ATP_Error - Error returned  --- %lX \n" ,TST_ATP_Error ));               
		return TESTFAIL;
	}
	else
	{
		ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"TST_massage - "));
		ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"%s","DX_VOS_MemCmp"));
		ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," Error returned correctly - Test pass \n"));                              
	}

  return TST_TestStatus;
} /*End of test*/


/*****************************************************/
/*TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************/
/*--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************/
/*TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR********************/
/*--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR--TESTS SEPARATOR******************/
/*****************************************************/
/***************************
 * Function Name:                                                           
 *  CRYS_Ext_ATP_RND_Reset        
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
 *  This function Is a Acceptance test for Random API's,
 *  implemented as external SEP application  
 *                                  
 * Algorithm:       
 * 1. Call the SEPQA_ECC_ECDSA_NonIntegratedSignVerify function to execute test
 * 2. Verify function succeded according to the returned error code
 *
 **************************/ 
CRYSError_t CRYS_Ext_ATP_RND_Reset ( void )

{

    /*** TST Variables Definitions ****/
    TST_RND_TestDataStruct  TST_RND_Results = {{0},{0}};    
    DxUint16_t                 TST_RNDSize = 762;
    CRYSError_t             TST_TestStatus=0;
    char                    TST_MasterTestName[TST_FUNC_STRING_LEN] = "CRYS_ATP_TST_RND_Acceptance_Reset";

    
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"************************ \n"));
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"** CRYS_ATP_TST_RND_Acceptance_Reset Tests          ******** \n"));       
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"************************ \n \n"));

    /****************/
    /***** Start of test ********/
    /****************/
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," ************************ \n"));
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," Random generation - Random Size = %d \n", TST_RNDSize));
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," ************************ \n"));

	TST_ATP_Error = SEPQA_RND_Reset(TST_RNDSize,
									FailureFunctionNameOut,
									FailureFunctionName_K_Size);

                           
    ATP_LOG_TST_DisplayBuffer (CRYS_ATP_TST_DBG_HIGH,
                                "\nTST_RND_Output1--\n",
                                TST_RND_Results.TST_RND_Output1,
                                TST_RNDSize);
                                
    ATP_LOG_TST_DisplayBuffer (CRYS_ATP_TST_DBG_HIGH,
                                "\nTST_RND_Output2--\n",
                                TST_RND_Results.TST_RND_Output2,
                                TST_RNDSize);                                                                      


    if (TST_ATP_Error == TESTPASS)
    {
    
        ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n!!!! TST_ATP_Error - Master Test Name -%s\n",TST_MasterTestName));
        ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"!!!! TST_ATP_Error - SubTest Name -%s\n","TST_RND_Output1+2"));           
        ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"!!!! TST_ATP_Error - %s failed\n","DX_VOS_MemCmp"));
        ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"!!!! TST_ATP_Error - Wrong Error returned!\n"));
        ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"!!!! TST_ATP_Error - Error returned  --- %lX \n" ,TST_ATP_Error ));               
        return TESTFAIL;
    }
    else
    {
        ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"TST_massage - "));
        ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"%s","DX_VOS_MemCmp"));
        ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," Error returned correctly - Test pass \n"));                              
    }
 
    return TST_TestStatus;
} /*End of test*/




